<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.css">
        <style>
            .tabb tr th {
                background-color: rgb(22, 128, 226);
                color: white;
                text-align: center;
            }

            .tabb tr td {
                vertical-align: middle
            }
        </style>
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-8">
                <x-message></x-message>
                <div class="card card-primary card-outline">

                    <div class="card-body">
                        <div class="table-responsive"
                            style="height: 400px; overflow: auto; border: 1px solid rgb(241, 237, 237); ">
                            <table class="table table-sm table-bordered table-hover  tabb">
                                <thead>
                                    <tr>
                                        <th width="2%">No</th>
                                        <th>Nama Barang</th>
                                        <th>Harga</th>
                                        <th width="17%">Qty</th>
                                        <th>Jumlah</th>
                                        <th width="4%">#</th>
                                    </tr>
                                </thead>
                                <tbody id="viewpenge">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <span style="float: right; font-size: 30px; font-weight: bold" id="ttl">Rp.0</span>
                        TOTAL:

                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label>Nama Barang</label>
                            <input type="text" name="nm_barang" id="nm_barang" class="form-control"
                                placeholder="Nama Barang">
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Qty</label>
                                    <input type="text" name="qty" id="qty" class="form-control numbers"
                                        placeholder="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Satuan</label>
                                    <select name="satuan" id="satuan" class="form-control">
                                        <option value="">Pilih</option>
                                        @foreach ($satuan as $s)
                                            <option value="{{ $s->id }}">{{ $s->nm_satuan }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Harga Satuan</label>
                                    <input type="text" name="harga" id="harga" class="form-control numbers"
                                        placeholder="Rp.0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-success btn-lg btn-block tambah" style="margin-top: 22px"><i
                                        class="fa fa-plus-circle"></i>
                                    Tambahkan</button>
                            </div>
                        </div>
                        <button class="btn btn-primary btn-lg btn-block" data-toggle="modal" data-target="#simpan"
                            style="margin-top: 22px"><i class="fa fa-save"></i>
                            Simpan </button>

                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title "><i class="fa fa-server text-primary mr-2"></i> Data {{ $data['page'] }}
                        </h3>
                    </div>
                    <div class="card-body">
                        <form class="form-inline float-right">
                            <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"
                                name="cari">
                            <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                Cari!</button>
                        </form>

                        <button class="btn btn-default shadow-sm">
                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                <input type="checkbox" id="cekall">
                                <label for="cekall">
                                </label>
                            </div>
                        </button>
                        <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i>
                            Hapus</button>
                        <table class="table table-bordered table-hover myTable tab mt-2">
                            <thead>
                                <tr>
                                    <th width="3%">No</th>
                                    <th>#</th>
                                    <th>No. Pengeluaran</th>
                                    <th>Supplier</th>
                                    <th>Tgl. Pembelian</th>
                                    <th>Total Belanja</th>
                                    <th width="10%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($pengeluaran as $p)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td class="text-center">
                                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                <input type="checkbox" name="id[]" id="cek{{ $p->id }}"
                                                    class="ceklis" value="{{ $p->id }}">
                                                <label for="cek{{ $p->id }}">
                                                </label>
                                            </div>
                                        </td>
                                        <td>{{ $p->kd_pengeluaran }}</td>
                                        <td>{{ $p->supplier->nm_supplier }}</td>
                                        <td>{{ tgl_inf($p->created_at) }} </td>
                                        <td class="text-right">{{ number_format($p->total, 0, ',', '.') }}</td>
                                        <td class="text-center">
                                            <button class="btn btn-success btn-sm detail"
                                                data-id="{{ $p->id }}"><i class="fa fa-search mr-2"></i>
                                                Detail</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <!-- /.card -->

    </section>

    <input type="hidden" name="" id="totalasl" value="0">

    {{-- simpan  --}}
    <div class="modal fade" id="simpan">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    TOTAL:
                    <span style="float: right; font-size: 30px; font-weight: bold" id="ttl2">Rp.0</span>
                </div>
                <div class="modal-body">
                    <div class="form-group row">
                        <label for="" class="col-sm-4 col-form-label">Pilih Supplier</label>
                        <div class="col-sm-8">
                            <select name="" id="supplier" class="form-control">
                                <option value="">Pilih</option>
                                @foreach ($supplier as $s)
                                    <option value="{{ $s->id }}">{{ $s->nm_supplier }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="" class="col-sm-4 col-form-label">Tanggal Pembelian</label>
                        <div class="col-sm-8">
                            <input type="date" name="" id="tgl" class="form-control"
                                value="{{ date('Y-m-d') }}">
                        </div>
                    </div>

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-success simpan_pengeluaran"><i class="fa fa-save mr-2"></i>
                        Simpan
                        Pengeluaran</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    {{-- detail  --}}
    <div class="modal fade" id="detail">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Detail Pengeuaran
                </div>
                <div class="modal-body" id="datadetail">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/pengeluran.js"></script>
    </x-slot:foot>
</x-admin.contents>
